/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block;

import com.mojang.serialization.MapCodec;
import io.github.foundationgames.automobility.block.entity.AutomobileAssemblerBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AutomobileAssemblerBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final Component USE_CROWBAR_DIALOG = Component.translatable((String)"dialog.automobility.use_crowbar").withStyle(ChatFormatting.GOLD);
    public static final Component INCOMPLETE_AUTOMOBILE_DIALOG = Component.translatable((String)"dialog.automobility.incomplete_automobile").withStyle(ChatFormatting.RED);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final MapCodec<AutomobileAssemblerBlock> CODEC = Block.simpleCodec(AutomobileAssemblerBlock::new);
    private static final VoxelShape BASE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape)Block.box((double)5.0, (double)4.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0));
    private static final VoxelShape NORTH_SOUTH = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)8.0, (double)6.0, (double)16.0, (double)12.0, (double)10.0));
    private static final VoxelShape EAST_WEST = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)12.0, (double)16.0));

    public AutomobileAssemblerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.neighborChanged(state, world, pos, block, fromPos, notify);
        boolean power = world.hasNeighborSignal(pos);
        if (power != (Boolean)state.getValue((Property)POWERED)) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(power)));
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!world.isClientSide() && placer instanceof Player) {
            Player player = (Player)placer;
            player.displayClientMessage(USE_CROWBAR_DIALOG, true);
        }
        super.setPlacedBy(world, pos, state, placer, itemStack);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AutomobileAssemblerBlockEntity) {
            AutomobileAssemblerBlockEntity assembler = (AutomobileAssemblerBlockEntity)blockEntity;
            return assembler.interact(player, stack, hand);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity blockEntity;
        if (!newState.is((Block)this) && (blockEntity = world.getBlockEntity(pos)) instanceof AutomobileAssemblerBlockEntity) {
            AutomobileAssemblerBlockEntity assembler = (AutomobileAssemblerBlockEntity)blockEntity;
            assembler.dropParts();
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST, Direction.WEST -> EAST_WEST;
            default -> NORTH_SOUTH;
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)super.getStateForPlacement(ctx).setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, POWERED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AutomobileAssemblerBlockEntity(pos, state);
    }
}

